#!/bin/bash
set -euo pipefail

PLUGIN_NAME_NEW="Pioneer MP Trigger"
PLUGIN_NAME_OLD="DrumTrigger"

SYSTEM_PATHS=(
  "/Library/Audio/Plug-Ins/VST3/${PLUGIN_NAME_NEW}.vst3"
  "/Library/Audio/Plug-Ins/Components/${PLUGIN_NAME_NEW}.component"
  "/Library/Audio/Plug-Ins/VST3/${PLUGIN_NAME_OLD}.vst3"
  "/Library/Audio/Plug-Ins/Components/${PLUGIN_NAME_OLD}.component"
)

USER_PATHS=(
  "$HOME/Library/Audio/Plug-Ins/VST3/${PLUGIN_NAME_NEW}.vst3"
  "$HOME/Library/Audio/Plug-Ins/Components/${PLUGIN_NAME_NEW}.component"
  "$HOME/Library/Audio/Plug-Ins/VST3/${PLUGIN_NAME_OLD}.vst3"
  "$HOME/Library/Audio/Plug-Ins/Components/${PLUGIN_NAME_OLD}.component"
  "$HOME/Library/Application Support/ISINDIE_DSP/PioneerMPTrigger/license_state.json"
  "$HOME/Library/Application Support/ISINDIE_DSP/DrumTrigger/license_state.json"
  "$HOME/Library/ISINDIE_DSP/PioneerMPTrigger/license_state.json"
  "$HOME/Library/ISINDIE_DSP/DrumTrigger/license_state.json"
)

PKG_IDS=(
  "com.isindie.pioneermptrigger.closedbeta"
  "com.isindie.drumtrigger.closedbeta"
)

echo "============================================="
echo " Pioneer MP Trigger - Uninstaller (macOS)"
echo "============================================="
echo

if [[ "$(uname -s)" != "Darwin" ]]; then
  echo "This uninstaller is for macOS only."
  exit 1
fi

echo "This will remove:"
echo "- AU/VST3 plugin files (system and user locations)"
echo "- local license/trial state files"
echo "- package receipts (if present)"
echo
read -r -p "Continue? [y/N]: " CONFIRM
if [[ "${CONFIRM:-}" != "y" && "${CONFIRM:-}" != "Y" ]]; then
  echo "Cancelled."
  exit 0
fi

echo
echo "Requesting admin rights for system cleanup..."
sudo -v

remove_path() {
  local p="$1"
  if [[ -e "$p" ]]; then
    echo "Removing: $p"
    rm -rf "$p"
  fi
}

echo
echo "Removing system plugin files..."
for p in "${SYSTEM_PATHS[@]}"; do
  if [[ -e "$p" ]]; then
    echo "Removing: $p"
    sudo rm -rf "$p"
  fi
done

echo
echo "Removing user plugin and license files..."
for p in "${USER_PATHS[@]}"; do
  remove_path "$p"
done

echo
echo "Forgetting installer receipts (if found)..."
for pkg in "${PKG_IDS[@]}"; do
  if pkgutil --pkgs | grep -q "^${pkg}$"; then
    echo "Forgetting receipt: $pkg"
    sudo pkgutil --forget "$pkg" >/dev/null
  fi
done

echo
echo "Done."
echo "Recommended: restart your DAW and rescan plugins."
echo
read -r -p "Press Enter to close..."
